import ddf.minim.*;
import de.looksgood.ani.*;
import javax.swing.*;

//debug mode
link selectedLink;
String[] previousNodes = new String[0];
boolean loadOnFocus = false;

//main
ArrayList <node> nodes = new ArrayList();
node activeNode;
String rootNode;

String worldDirectory;
File dataDirectory;
File resourceDirectory;

PImage picture;
AudioPlayer ambientSound;
Minim minim;
boolean debug = false;
PVector linkOffset = new PVector();
PVector picturePosition = new PVector();

//transitions & animation
int transitionValue = 255;
boolean transitioning;
String nextNode;

//fonts
PFont debugFont;
PFont captionFont;

/* TODO
 
 *sooner
 
 
 make a class for transitions?
 add transition:times
 write import single node function
 
 *later
 link resize constraints
 link collision detection
 implement an audio transition system
 consider implementing space audio / tagged audio
 figure out fullscreen mode
 possibly only load one node at a time?
 
 *casual
 mess around with cursors
 clean up loading code a little bit
 preload linked node data
 
 */

// PROGRAM FLOW

void setup() {
  size(1024, 768, JAVA2D); 
  hint(DISABLE_OPENGL_2X_SMOOTH);
  hint(ENABLE_NATIVE_FONTS);
  frame.setResizable(true);
  //noLoop();
  noStroke();

  debugFont = loadFont("Monaco-10.vlw");
  captionFont = loadFont("HelveticaNeue-18.vlw"); 

  //initialize sound & animation library
  minim = new Minim(this);
  Ani.init(this);

  //import data and load first node
  worldDirectory = selectFolder();

  if (worldDirectory == null || worldDirectory.equals("")) {
    exit();
  } 
  else {
    dataDirectory = new File(worldDirectory+"/data");
    resourceDirectory = new File(worldDirectory+"/resources");
    import_nodes(worldDirectory);
    rootNode = loadStrings(worldDirectory+"/saved.txt")[0];
    previousNodes = append(previousNodes, rootNode);
    load_node(rootNode);
  }
}

void draw() {

  background(0);

  if (transitioning) tint(255, transitionValue);

  image(picture, picturePosition.x, picturePosition.y);

  if (activeNode.caption != "") {
    textAlign(CENTER);
    textFont(captionFont);
    fill(255);
    rectMode(CENTER);
    text(activeNode.caption, width/2, height/2+384-38);
    rectMode(CORNER);
  }

  if (debug) {
    textAlign(LEFT);
    textFont(debugFont);
    text(activeNode.name, 5, 15);
    for (link l : activeNode.links) {
      fill(0, 180, 0, 120);
      stroke(255);
      rect(l.hitSpot[0], l.hitSpot[1], l.hitSpot[2], l.hitSpot[3]);
      fill(255, 0, 0, 128);
      noStroke();
      rect(l.hitSpot[0]+l.hitSpot[2]-10, l.hitSpot[1]+l.hitSpot[3]-10, 10, 10);
      fill(255);
      text(l.to, l.hitSpot[0]+3, l.hitSpot[1]+l.hitSpot[3]-2);
    }
  }
}

void stop()
{
  if (activeNode != null) {
    String[] save = {
      activeNode.name
    };
    saveStrings(worldDirectory+"/saved.txt", save);
    if (activeNode.sound != null) activeNode.sound.close();
    minim.stop();
    super.stop();
    exit();
  }
}


//INPUT

void mousePressed() {

  if (debug) {
    for (link l : activeNode.links) {
      if (rect_hit(mouseX, mouseY, l.hitSpot[0], l.hitSpot[1], l.hitSpot[2], l.hitSpot[3])) {
        selectedLink = l; 
        linkOffset = new PVector(mouseX-l.hitSpot[0], mouseY-l.hitSpot[1]);
      }
    }
  }
}

void mouseDragged() {

  PVector tempHitSpot = new PVector();

  if (debug && selectedLink != null) {

    tempHitSpot.x = mouseX - int(linkOffset.x);
    tempHitSpot.y = mouseY - int(linkOffset.y);

    if (linkOffset.x > selectedLink.dimension.x - 10 && linkOffset.y > selectedLink.dimension.y - 10) {
      selectedLink.hitSpot[2] = (mouseX-selectedLink.hitSpot[0]) - (int(linkOffset.x) - int(selectedLink.dimension.x));
      selectedLink.hitSpot[3] = (mouseY-selectedLink.hitSpot[1]) - (int(linkOffset.y) - int(selectedLink.dimension.y));
    } 
    else {
      if (tempHitSpot.x+selectedLink.hitSpot[2] > picturePosition.x + picture.width) {
        tempHitSpot.x = (picturePosition.x + picture.width) - selectedLink.hitSpot[2];
      }
      if (tempHitSpot.x < picturePosition.x) {
        tempHitSpot.x = picturePosition.x;
      }
      if (tempHitSpot.y < picturePosition.y) {
        tempHitSpot.y = picturePosition.y;
      }
      if (tempHitSpot.y+selectedLink.hitSpot[3] > picturePosition.y + picture.height) {
        tempHitSpot.y = (picturePosition.y + picture.height) - selectedLink.hitSpot[3];
      }
      selectedLink.hitSpot[0] = int(tempHitSpot.x);
      selectedLink.hitSpot[1] = int(tempHitSpot.y);
    }
  }
}

void mouseReleased() {

  for (link l : activeNode.links) {
    if (rect_hit(mouseX, mouseY, l.hitSpot[0], l.hitSpot[1], l.hitSpot[2], l.hitSpot[3])) {
      if (debug == false) {
        for (node n : nodes) {
          if (n.name.equals(l.to)) {
            nextNode = l.to;
            transition("out");
          }
        }
      }
      return;
    }
  }
  if (rect_hit(mouseX, mouseY, int(picturePosition.x), int(picturePosition.y), picture.width, picture.height)) {
    if (debug == false) {
      if (activeNode.defaultLink.equals("")) {
        return;
      } 
      else nextNode = activeNode.defaultLink;
      transition("out");
    }
  } 
  else previous_node();

  if (selectedLink != null) {
    selectedLink.dimension.x = selectedLink.hitSpot[2];
    selectedLink.dimension.y = selectedLink.hitSpot[3];
    selectedLink.pos.x = selectedLink.hitSpot[0] - picturePosition.x;
    selectedLink.pos.y = selectedLink.hitSpot[1] - picturePosition.y;
    selectedLink = null;
  }
}

void keyPressed() {

  switch(keyCode) {

  case ESC:
    stop();
    break;

  case SHIFT:
    debug=!debug;
    loadOnFocus = true;
    break;

  case ALT:
    loadOnFocus = false;
    activeNode.new_link();
    break;

  case ENTER:
    export_nodes();
    break;

  case BACKSPACE:
    previous_node();
    break;

  case DELETE:
    break;

  case TAB:
    import_nodes(worldDirectory);
    load_node(activeNode.name);
    redraw();
    break;
  }

  switch(key) {

  case '1':
    break;
  }
}

// PREPARE NODE

void load_node(String name) {
  for (node n : nodes) {
    if (n.name.equals(name)) {
      if (activeNode != null && activeNode != n) {
        if (previousNodes.length > 0 && previousNodes[previousNodes.length-1].equals(n.name)==false) {
          previousNodes = append(previousNodes, activeNode.name);
        }
      }
      activeNode = n;
      picture = activeNode.load_picture();
      picturePosition = new PVector(width/2-picture.width/2, height/2-picture.height/2);
      if (activeNode.soundPath != "") activeNode.sound = activeNode.load_sound();
      calculate_link_positions();
      if (activeNode.sound != null) activeNode.sound.play();
      transition("in");
      break;
    }
  }
}

// WINDOW EVENTS

void focusGained() {
  if (loadOnFocus) {
    import_nodes(worldDirectory);
    load_node(activeNode.name);
  }
}

// EDITING FEATURES




// IMPORT & EXPORT

void import_nodes(String worldDirectory) {

  nodes.clear();

  File[] txtFiles = dataDirectory.listFiles();

  for (File txtFile : txtFiles) {

    String name = "";
    String defaultLink = "";
    String imagePath = "";
    String soundPath = "";
    String caption = "";
    String[] imageTags = new String[0]; 
    String[] soundTags = new String[0]; 
    link[] links = new link[0];

    String txtFileName = txtFile.getName();

    if (txtFileName.substring(txtFileName.lastIndexOf('.')+1).equals("txt")) {

      name = txtFileName.substring(0, txtFileName.lastIndexOf('.'));
      String[] database = loadStrings(txtFile);

      for (String s : database) {

        if (s.length() > 0) {

          switch(s.charAt(0)) {

          case '>':
            s = s.substring(2);
            defaultLink = s;
            break;

          case '+':
            s = s.substring(2);
            String[] linkName = s.split(" ` ");
            String[] linkValues = linkName[1].split("[.:]");
            link l = new link(linkName[0], int(linkValues[0]), int(linkValues[1]), int(linkValues[2]), int(linkValues[3]));
            links = (link[]) append(links, l);
            break;

          case '#':
            s = s.substring(2);
            imageTags = s.split(" ");
            break; 

          case '$':
            s = s.substring(2);
            soundTags = s.split(" ");
            break;

          case '\"':
            s = s.substring(2);
            caption = s;
            break;
          }
        }
      }
    } 
    else continue;

    File nodeDirectory = new File(resourceDirectory+"/"+name);
    File[] resourceFiles = nodeDirectory.listFiles();

    for (File resourceFile : resourceFiles) {
      String resourceFileName = resourceFile.getName();
      String ext = resourceFileName.substring(resourceFileName.lastIndexOf('.')+1);
      if (ext.equals("jpg") || ext.equals("JPG") || ext.equals("png")) {
        imagePath = resourceFileName;
      }
      else if (ext.equals("mp3")) {
        soundPath = resourceFileName;
      }
    }
    nodes.add(new node(name, defaultLink, imagePath, soundPath, caption, imageTags, soundTags, links));
    links = new link[0];
  }
}

void export_nodes() {

  for (node n : nodes) {

    String[] i = new String[0];

    i = append(i, ">\t"+n.defaultLink);
    for (link l : n.links) {
      i = append(i, "+\t"+l.to+" ` "+int(l.pos.x)+"."+int(l.pos.y)+":"+int(l.dimension.x)+"."+int(l.dimension.y));
    }
    i = append(i, "");
    i = append(i, "#\t"+tags_to_string(n.imageTags));
    i = append(i, "$\t"+tags_to_string(n.soundTags));
    i = append(i, "");
    i = append(i, "\"\t"+n.caption);

    saveStrings(dataDirectory+"/"+n.name+".txt", i);
  }
}


// GEOMETRY AND GRAPHICS CALCULATIONS

boolean rect_hit(int x, int y, int rectX, int rectY, int rectW, int rectH) {
  if (x > rectX && x < rectW+rectX && y > rectY && y < rectH+rectY) {
    return true;
  } 
  else return false;
}

void calculate_link_positions() {
  for (link l : activeNode.links) {
    PVector topLeft = new PVector(picturePosition.x, picturePosition.y);
    int[] calculatedPosition = {
      int(topLeft.x + l.pos.x), int(topLeft.y + l.pos.y), int(l.dimension.x), int(l.dimension.y)
    };  
    l.hitSpot = calculatedPosition;
  }
}

/* not being used
 void drag_picture() {
 picturePosition.x += mouseX-pmouseX;
 picturePosition.y += mouseY-pmouseY;
 
 if (picturePosition.x > width-picture.width/2) {
 picturePosition.x = width-picture.width/2;
 }
 if (picturePosition.x < -picture.width/2) {
 picturePosition.x = -picture.width/2;
 }
 if (picturePosition.y > height-picture.height/2) {
 picturePosition.y = height-picture.height/2;
 }
 if (picturePosition.y < -picture.height/2) {
 picturePosition.y = -picture.height/2;
 }
 calculate_link_positions();
 }
 */

boolean link_hit() {
  for (link l : activeNode.links) {
    if (rect_hit(mouseX, mouseY, l.hitSpot[0], l.hitSpot[1], l.hitSpot[2], l.hitSpot[3])) {
      return true;
    }
  } 
  return false;
}


// NODE TRANSITIONS

void previous_node() {

  if (previousNodes.length > 1) {
    load_node(previousNodes[previousNodes.length-1]);
    if (previousNodes.length > 0) previousNodes = shorten(previousNodes);
  }
}

void transition_started() {
  transitioning = true;
}

void transition_ended() {
  transitioning = false;
}

void transition_out_ended() {
  transitioning = false;
  load_node(nextNode);
}

int transitionEndValue = 0;


void transition(String placement) { // one transition function to go from out => in  transition(nodeNameToTransitionTo) <- read values from node + make transition class?


  if (placement.equals("in")) {
    transitionValue = 0;
    transitionEndValue = 255;
    Ani.to(this, 0.5, "transitionValue", transitionEndValue, Ani.LINEAR, "onStart:transition_started, onEnd:transition_ended");
  } 
  else if (placement.equals("out")) {
    transitionValue = 255;
    transitionEndValue = 0;
    Ani.to(this, 0.5, "transitionValue", transitionEndValue, Ani.LINEAR, "onStart:transition_started, onEnd:transition_out_ended");
  }
}


// UTILITIES

String tags_to_string(String[] nodeTags) {
  String tags ="";
  for (int t = 0; t < nodeTags.length; t++) {
    tags += nodeTags[t];
    if (t != nodeTags.length - 1) {
      tags+=" ";
    }
  }
  return tags;
}

